/*
 * pi-26.c
 * Copyright (C) 2013 drdev <drdev@localhost.com>
 * 
 * pi-26 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Pi-26 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

 /*
   Converts a file containing a decimal value of pi to the equivalent radix-26
   encoded as a-z rather than 0-p
   Notes - Need to install libgmp3-dev package to get <gmp.h>
   and libmpfr-dev to get <mpfr.h>
   Add -lgmp and -lmpfr to Makefile.am 
   compile with gcc -o pi-26 pi-26.c -lmpfr -lgmp -lm
   execute in terminal with ./pi-26
*/

#include <stdio.h>
#include<string.h>
#include <gmp.h>
#include <mpfr.h>

#define pi_digits 1000000+1 //extra character for null-terminated string

long fctr;
unsigned int i;
char pi_26[pi_digits]="";
mpfr_t s;
mpfr_exp_t e;
char pi[pi_digits] = "";
char fn1[64]="pi_million.txt";
FILE *indata;
char fn2[64]="output.txt";
FILE *outdata;

/* Prototypes */
void exit(int status);

int main (void)
{

printf("\nInput file selected = %s\n",fn1);

if ((indata = fopen(fn1,"rb"))==NULL)
	{printf ("\nInput file cannot be opened.\n");
	exit (1);}

printf("\nOutput file selected = %s\n",fn2);

if ((outdata = fopen(fn2,"w"))==NULL)
	{printf ("\nOutput file cannot be opened.\n");
	exit (1);}

fctr = 0;

while(fctr<(pi_digits-1))
{
pi[fctr] = getc(indata);
fctr++;
}
pi[fctr]='\0';

fclose(indata);

mpfr_set_default_prec ((int)3.322*pi_digits); //These are bits of precision.  log(10)/log(2) = 3.322
mpfr_init_set_str (s, pi, 10, MPFR_RNDD);

/*
//to show intermediare results
  printf ("Pi is ");
  mpfr_out_str (stdout, 10, 0, s, MPFR_RNDD);
  putchar ('\n');
  mpfr_out_str (stdout, 26, 0, s, MPFR_RNDD);
  putchar ('\n');
*/
  mpfr_get_str (pi_26, &e, 26, 0, s, MPFR_RNDN);
//lower case 'a' is ascii 97, 0=ASCII 48 9=ASCII 57
  printf("\n");
for (fctr=0;fctr<strlen(pi_26);fctr++)
{
if (pi_26[fctr]<97)
{
printf("%c",pi_26[fctr]+(97-48));
fprintf(outdata,"%c",pi_26[fctr]+(97-48));
}
else
{
printf("%c",pi_26[fctr]+10);
fprintf(outdata,"%c",pi_26[fctr]+10);
}
}
  printf("\n");
  mpfr_clear (s);
  mpfr_free_cache ();
  fclose(outdata);
  return 0;

}


